
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1005.C - Message 1005 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1005 messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\MSG1005.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:44   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:37:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:05:18   COLEJ
//    
//   
//      Rev 1.1   Aug 14 1996 09:32:22   COLEJ
//   Repositioned sequence number up one.
//   
//   
//      Rev 1.0   13 May 1996 14:52:42   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <graph.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1005 message from the ZMsgBuf.
//      
void Dec1005(tMSGBUF *ZMsgBuf, tMSG1005 *Msg)
{  
   tSHORT i;

   GetBit(&DiffStatusBits.StationUnhealthy, ZMsgBuf,  9, 0); // 1=true
   GetBit(&DiffStatusBits.UserDisabled    , ZMsgBuf,  9, 1); // 1=true

   for(i=0; i<GI_MAX_VIS_SVS; i++)  {
      GetBits(&CorrStatusBits[i].PRN                   , ZMsgBuf,13+i, 0, 6); // ND
      GetBits(&CorrStatusBits[i].EphemerisNotPresent   , ZMsgBuf,13+i, 6, 1); // ND
      GetBits(&CorrStatusBits[i].CorrectionsNotPresent , ZMsgBuf,13+i, 7, 1); // ND
      GetBits(&CorrStatusBits[i].UDREHigh              , ZMsgBuf,13+i, 8, 1); // ND
      GetBits(&CorrStatusBits[i].SatelliteUnhealthy    , ZMsgBuf,13+i, 9, 1); // ND
      GetBits(&CorrStatusBits[i].CorrectionsBad        , ZMsgBuf,13+i,10, 1); // ND
      GetBits(&CorrStatusBits[i].CorrectionsStale      , ZMsgBuf,13+i,11, 1); // ND
      GetBits(&CorrStatusBits[i].IODEMismatch          , ZMsgBuf,13+i,12, 1); // ND
   }                                              
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1005 message in the ZMsgBuf.
//
void Bld1005(tMSGBUF *ZMsgBuf, tMSG1005 *Msg)
{
   // ack flags assumed preset

   PutShort  (0x81FF                       , ZMsgBuf, 1);         // message preamble
   PutShort  (1005                         , ZMsgBuf, 2);         // message number
   PutShort  (0                            , ZMsgBuf, 3);         // message length 
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);         // header check sum                                             

   //PutShort  (CheckSum(ZMsgBuf, 6, 197)       , ZMsgBuf, 203);   // data check sum 
}

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1005 message from the ZMsgBuf.
//      
void Show1005(tMSG1005 *Msg)
{  
   char    Buf[80] = ""; 
   tSHORT  i;

  
   // convert values  
   
   // perform special processing for output
                                                    
   // output the data values
   sprintf(Buf,"%05d" ,Msg->SequenceNumber);ShowText(Buf,TIMR+ 6,TIMC+ 4);

   sprintf(Buf,"%4d"  ,Msg->StationID     );ShowText(Buf,DSTR   ,DSTC- 6);
   sprintf(Buf,"%3d"  ,Msg->AgeOfLastCorrections);
                                            ShowText(Buf,DSTR+1 ,DSTC- 5);

   if(DiffStatusBits.UserDisabled){
      ShowText("DISABLED",DSTR+ 2,DSTC- 5);
   }
   else{
      ShowText("ENABLED ",DSTR+ 2,DSTC- 5);
   }                                    
   sprintf(Buf,"%1d"  ,DiffStatusBits.StationUnhealthy ? 1 : 0);
                                        ShowText(Buf,DSTR  ,DSTC+ 4);

   for(i=0; i < (short) Msg->NumberObservations; i++)
   {
      sprintf(Buf,"%2d" ,CorrStatusBits[i].PRN); 
                                        ShowText(Buf,DGSR+i,DGSC);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].EphemerisNotPresent ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+3);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].CorrectionsNotPresent ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+4);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].UDREHigh ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+5);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].SatelliteUnhealthy ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+6);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].CorrectionsBad ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+7);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].CorrectionsStale ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+8);
      sprintf(Buf,"%1d" ,CorrStatusBits[i].IODEMismatch ? 1 : 0);
                                        ShowText(Buf,DGSR+i,DGSC+9);
   }
   
   // clear remaining space
   while(i < GI_MAX_VIS_SVS){
      ShowText("           ",DGSR+i++,DGSC);
   }  
}
